;
!define PRODUCT_NAME "Opera"
!define PRODUCT_VERSION "11.51"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define BRANDING "Svetonosny Angel"
!define pkgdir "D:\NSIS"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${pkgdir}\opera1.bmp"
!define MUI_UNWELCOMEFINISHPAGE_BITMAP "${pkgdir}\opera1.bmp"
!define HelpLink "http://www.opera.com/support"
!define URLInfoAbout "http://www.opera.com"
!define URLUpdateInfo "http://www.opera.com/download" 
!define PRODUCT_WEB_SITE "http://www.opera.com"
!define Comments "        "
!define SHCNE_ASSOCCHANGED 0x08000000
!define SHCNF_IDLIST 0
;
; MUI 1.67 compatible ------
;!include "MUI.nsh"
!include "MUI2.nsh"
!include "FileFunc.nsh"
!include "Sections.nsh"
;
SetCompressor /SOLID lzma
SetCompressorDictSize 64
;
; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "D:\NSIS\Opera.ico"
!define MUI_UNICON "D:\NSIS\OperaUn.ico"
!define MUI_COMPONENTSPAGE_SMALLDESC
;
; installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
;
; Uninstaller pages
!insertmacro MUI_UNPAGE_WELCOME 
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_COMPONENTS
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH
;
; Language files
!insertmacro MUI_LANGUAGE "Russian"
;
!insertmacro RefreshShellIcons
;
Name "${PRODUCT_NAME}"
Caption " ${PRODUCT_NAME} ${PRODUCT_VERSION}"
UninstallCaption " ${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
BrandingText "${BRANDING}"
;
Var SysDrive
;
Section "   " ID_1
SetShellVarContext current
SetOutPath "$APPDATA"
IfFileExists "$APPDATA\Opera\Opera\*.ini" 0 check_programdir
IfSilent +2    
MessageBox MB_YESNO|MB_ICONQUESTION "  Opera    .        ?    $DOCUMENTS\Opera Backup" IDNO no_backup
CreateDirectory "$DOCUMENTS\Opera Backup\AppData\Opera"
CreateDirectory "$DOCUMENTS\Opera Backup\LocalAppData\Opera"
;
CopyFiles /silent "$APPDATA\Opera\Opera\*.ini" "$DOCUMENTS\Opera Backup\AppData\Opera"
CopyFiles /silent "$APPDATA\Opera\Opera\*.adr" "$DOCUMENTS\Opera Backup\AppData\Opera"
CopyFiles /silent "$APPDATA\Opera\Opera\*.dat" "$DOCUMENTS\Opera Backup\AppData\Opera"
CopyFiles /silent "$APPDATA\Opera\Opera\*.xml" "$DOCUMENTS\Opera Backup\AppData\Opera"
CopyFiles /silent "$APPDATA\Opera\Opera\*.js" "$DOCUMENTS\Opera Backup\AppData\Opera"
CopyFiles /silent "$APPDATA\Opera\Opera\sessions" "$DOCUMENTS\Opera Backup\AppData\Opera\sessions"
CopyFiles /silent "$APPDATA\Opera\Opera\toolbar" "$DOCUMENTS\Opera Backup\AppData\Opera\toolbar"
CopyFiles /silent "$APPDATA\Opera\Opera\menu" "$DOCUMENTS\Opera Backup\AppData\Opera\menu"
CopyFiles /silent "$APPDATA\Opera\Opera\skin" "$DOCUMENTS\Opera Backup\AppData\Opera\skin"
CopyFiles /silent "$APPDATA\Opera\Opera\keyboard" "$DOCUMENTS\Opera Backup\AppData\Opera\keyboard"
CopyFiles /silent "$APPDATA\Opera\Opera\mouse" "$DOCUMENTS\Opera Backup\AppData\Opera\mouse"
;
SetOutPath "$LOCALAPPDATA"
CopyFiles /silent "$LOCALAPPDATA\Opera\Opera\mail" "$DOCUMENTS\Opera Backup\LocalAppData\Opera\mail"
CopyFiles /silent "$LOCALAPPDATA\Opera\Opera\cache" "$DOCUMENTS\Opera Backup\LocalAppData\Opera\cache"
;
goto check_programdir
check_programdir:
SetShellVarContext all
SetOutPath "$INSTDIR"
IfFileExists "$INSTDIR\Profile\*.ini" 0 no_backup
IfSilent +2   
MessageBox MB_YESNO|MB_ICONQUESTION "  Opera    .       ?    $DOCUMENTS\Opera Backup" IDNO no_backup
CreateDirectory "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile"
;
CopyFiles /silent "$INSTDIR\Profile\*.ini" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile"
CopyFiles /silent "$INSTDIR\Profile\*.adr" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile"
CopyFiles /silent "$INSTDIR\Profile\*.dat" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile"
CopyFiles /silent "$INSTDIR\Profile\*.xml" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile"
CopyFiles /silent "$INSTDIR\Profile\*.js" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile"
CopyFiles /silent "$INSTDIR\Profile\sessions" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\sessions"
CopyFiles /silent "$INSTDIR\Profile\toolbar" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\toolbar"
CopyFiles /silent "$INSTDIR\Profile\menu" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\menu"
CopyFiles /silent "$INSTDIR\Profile\skin" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\skin"
CopyFiles /silent "$INSTDIR\Profile\keyboard" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\keyboard"
CopyFiles /silent "$INSTDIR\Profile\mouse" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\mouse"
CopyFiles /silent "$INSTDIR\Profile\mail" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\mail"
CopyFiles /silent "$INSTDIR\Profile\cache" "$DOCUMENTS\Opera Backup\ProgramDir\Opera\profile\cache"
goto no_backup
no_backup:   
;
SetShellVarContext all
SetOutPath "$APPDATA"
RMDir /r "$APPDATA\Opera\"
RMDir /r "$LOCALAPPDATA\Opera\" 
;
RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
Delete "$Desktop\${PRODUCT_NAME}.lnk"
Delete "$QUICKLAUNCH\${PRODUCT_NAME}.lnk"
;
StrCpy $R0 "$SysDrive\Documents and Settings\\Local Settings\Application Data\Opera\"
SetEnv::SetEnvVar "PATH" $R0
RMDir /r "$R0\"
StrCpy $R1 "$SysDrive\Documents and Settings\\Application Data\Opera\"
SetEnv::SetEnvVar "PATH" $R1
RMDir /r "$R1\"
;
SetShellVarContext current
SetOutPath "$APPDATA"
RMDir /r "$APPDATA\Opera\"
RMDir /r "$LOCALAPPDATA\Opera\" 
;
ReadRegStr $0 HKLM "Software\Classes\.htm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.htm" ""
;
ReadRegStr $0 HKLM "Software\Classes\.html" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.html" ""
;
ReadRegStr $0 HKLM "Software\Classes\.mht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.mht" ""
;
ReadRegStr $0 HKLM "Software\Classes\.mhtml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.mhtml" ""
;
ReadRegStr $0 HKLM "Software\Classes\.xht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.xht" ""
;
ReadRegStr $0 HKLM "Software\Classes\.xhtm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.xhtm" ""
;
ReadRegStr $0 HKLM "Software\Classes\.xml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.xml" ""
;
ReadRegStr $0 HKLM "Software\Classes\.wgt" ""
StrCmp $0 "Opera.Widget" 0 +2
DeleteRegValue HKLM "Software\Classes\.wgt" ""
;
ReadRegStr $0 HKLM "Software\Classes\.oex" ""
StrCmp $0 "Opera.Extension" 0 +2
DeleteRegValue HKLM "Software\Classes\.oex" ""
;
ReadRegStr $0 HKCU "Software\Classes\.htm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.htm" ""
;
ReadRegStr $0 HKCU "Software\Classes\.html" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.html" ""
;
ReadRegStr $0 HKCU "Software\Classes\.mht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.mht" ""
;
ReadRegStr $0 HKCU "Software\Classes\.mhtml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.mhtml" ""
;
ReadRegStr $0 HKCU "Software\Classes\.xht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.xht" ""
;
ReadRegStr $0 HKCU "Software\Classes\.xhtm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.xhtm" ""
;
ReadRegStr $0 HKCU "Software\Classes\.xml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.xml" ""
;
ReadRegStr $0 HKCU "Software\Classes\.wgt" ""
StrCmp $0 "Opera.Widget" 0 +2
DeleteRegValue HKCU "Software\Classes\.wgt" ""
;
ReadRegStr $0 HKCU "Software\Classes\.oex" ""
StrCmp $0 "Opera.Extension" 0 +2
DeleteRegValue HKCU "Software\Classes\.oex" ""
;
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Widget" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Protocol" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Extension" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.HTML" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Image" ""
;
DeleteRegKey HKCU "Software\Classes\Opera.Widget" ""
DeleteRegKey HKCU "Software\Classes\Opera.Protocol" ""
DeleteRegKey HKCU "Software\Classes\Opera.Extension" ""
DeleteRegKey HKCU "Software\Classes\Opera.HTML" ""
DeleteRegKey HKCU "Software\Classes\Opera.Image" ""
;
DeleteRegKey /ifempty HKCU "Software\Classes\.htm" 
DeleteRegKey /ifempty HKCU "Software\Classes\.html" 
DeleteRegKey /ifempty HKCU "Software\Classes\.mht" 
DeleteRegKey /ifempty HKCU "Software\Classes\.mhtml" 
DeleteRegKey /ifempty HKCU "Software\Classes\.xht" 
DeleteRegKey /ifempty HKCU "Software\Classes\.xhtm" 
DeleteRegKey /ifempty HKCU "Software\Classes\.xml" 
DeleteRegKey /ifempty HKCU "Software\Classes\.wgt" 
DeleteRegKey /ifempty HKCU "Software\Classes\.oex" 
;
DeleteRegKey HKLM "SOFTWARE\Classes\.wgt" ""
DeleteRegKey HKLM "SOFTWARE\Classes\.oex" ""
DeleteRegKey HKLM "SOFTWARE\Classes\.xht" ""
DeleteRegKey HKLM "SOFTWARE\Classes\.xhtm" ""
DeleteRegKey HKLM "SOFTWARE\Classes\.xhtml" ""
;
DeleteRegKey HKLM "SOFTWARE\Classes\Applications\Opera.exe" ""
DeleteRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Opera.exe" "" 
;
DeleteRegKey HKLM "SOFTWARE\Clients\StartMenuInternet\Opera" ""
DeleteRegKey HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe" ""
;
DeleteRegKey HKLM "SOFTWARE\Clients\Mail\Opera" ""
DeleteRegKey HKLM "SOFTWARE\Clients\News\Opera" ""
DeleteRegKey HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe" ""
DeleteRegValue HKLM "SOFTWARE\RegisteredApplications" "Opera Internet Browser"  
DeleteRegValue HKLM "SOFTWARE\Classes\.bmp\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.gif\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.jpg\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.jpeg\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.oga\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.ogg\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.ogm\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.ogv\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.png\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.torrent\OpenWithProgids" "Opera.HTML" 
DeleteRegValue HKLM "SOFTWARE\Classes\.webm\OpenWithProgids" "Opera.Image" 
;
RMDir /r "$PROGRAMFILES\Opera" 
SectionEnd
;
Section "! ${PRODUCT_NAME}${PRODUCT_VERSION}" ID_2
SectionIn RO
SetOutPath "$INSTDIR"
File "${pkgdir}\Opera11\c3nform.vxml"
File "${pkgdir}\Opera11\encoding.bin"
File "${pkgdir}\Opera11\files.sig"
File "${pkgdir}\Opera11\files_list"
File "${pkgdir}\Opera11\files_old.sig"
File "${pkgdir}\Opera11\html40_entities.dtd"
File "${pkgdir}\Opera11\lngcode.txt"
File "${pkgdir}\Opera11\mathml.dtd"
File "${pkgdir}\Opera11\opera.dll"
File "${pkgdir}\Opera11\opera.exe"
File "${pkgdir}\Opera11\operaprefs_default.ini"
File "${pkgdir}\Opera11\opera_install_log.xml"
File "${pkgdir}\Opera11\operaURL.ico"
;
File /r "${pkgdir}\Opera11\defaults"
File /r "${pkgdir}\Opera11\extra"
File /r "${pkgdir}\Opera11\gstreamer"
File /r "${pkgdir}\Opera11\locale"
File /r "${pkgdir}\Opera11\program"
File /r "${pkgdir}\Opera11\skin"
File /r "${pkgdir}\Opera11\styles"
File /r "${pkgdir}\Opera11\ui"
File /r "${pkgdir}\Opera11\unite"
;
WriteUninstaller "$INSTDIR\uninst.exe"  
;
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\opera.exe"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "HelpLink" "${HelpLink}"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${URLInfoAbout}"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLUpdateInfo" "${URLUpdateInfo}"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Comments" "${Comments}"
;
WriteRegStr HKLM "SOFTWARE\Netscape\Netscape Navigator" "" ""
WriteRegStr HKLM "SOFTWARE\Netscape\Netscape Navigator" "CurrentVersion" "Opera"
WriteRegStr HKLM "SOFTWARE\Netscape\Netscape Navigator\Opera" "" ""
WriteRegStr HKLM "SOFTWARE\Netscape\Netscape Navigator\Opera\main" "Install Directory" "$INSTDIR"
WriteRegStr HKLM "SOFTWARE\Netscape\Netscape Navigator\Opera\main" "Plugins Directory" "$INSTDIR\program\plugins"
;
WriteRegStr HKCU "Software\Opera Software" "Plugin Path" "$INSTDIR\program\plugins"
WriteRegStr HKLM "SOFTWARE\Opera Software" "Plugin Path" "$INSTDIR\program\plugins"
;
WriteRegStr HKCU "Software\Opera Software" "Last CommandLine v2" "$INSTDIR\Opera.exe "
WriteRegStr HKCU "Software\Opera Software" "Last Install Path" "$INSTDIR"
;
WriteRegStr HKLM "SOFTWARE\Classes\Applications\Opera.exe" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Applications\Opera.exe\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Applications\Opera.exe\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Applications\Opera.exe\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\opera.exe" "" "$INSTDIR\opera.exe"
WriteRegStr HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\opera.exe" "Path" "$INSTDIR"
;
WriteRegStr HKLM "SYSTEM\CurrentControlSet\Services\SharedAccess\Parameters\FirewallPolicy\StandardProfile\AuthorizedApplications\List" "$PROGRAMFILES\Opera\opera.exe" "$PROGRAMFILES\Opera\Opera.exe:*:Enabled:Opera Internet Browser"
;
WriteRegStr HKLM "SYSTEM\ControlSet002\Services\SharedAccess\Parameters\FirewallPolicy\StandardProfile\AuthorizedApplications\List" "$PROGRAMFILES\Opera\opera.exe" "$PROGRAMFILES\Opera\Opera.exe:*:Enabled:Opera Internet Browser"
;
WriteRegStr HKLM "SOFTWARE\Microsoft\MediaPlayer\ShimInclusionList\OPERA.EXE" "" ""
SectionEnd
;
Section " " ID_3
SetOutPath "$INSTDIR"
WriteINIStr "$INSTDIR\operaprefs_default.ini" "System" "Multi User" "1"
SectionEnd
;
Section /o " " ID_4
SetOutPath "$INSTDIR"
WriteINIStr "$INSTDIR\operaprefs_default.ini" "System" "Multi User" "0"
SectionEnd
;
Section "Opera -  " ID_5
SetOutPath "$INSTDIR"
;
WriteRegStr HKLM "SOFTWARE\Classes\CLSID\{42042206-2D85-11D3-8CFF-005004838597}\Old Icon\Opera.HTML" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\CLSID\{42042206-2D85-11D3-8CFF-005004838597}\Old Icon\Opera.HTML\DefaultIcon" "" "$INSTDIR\Opera.exe,1"
;
WriteRegStr HKCR "CLSID\{42042206-2D85-11D3-8CFF-005004838597}\Old Icon\Opera.HTML" "" ""
WriteRegStr HKCR "CLSID\{42042206-2D85-11D3-8CFF-005004838597}\Old Icon\Opera.HTML\DefaultIcon" "" "$INSTDIR\Opera.exe,1"
;
DeleteRegValue  HKLM "SOFTWARE\Clients\StartMenuInternet" "" 
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet" "" "Opera.exe"
;
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera" "" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",0"
;
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\InstallInfo" "ShowIconsCommand" "$\"$INSTDIR\Opera.exe$\" /ShowIconsCommand"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\InstallInfo" "HideIconsCommand" "$\"$INSTDIR\Opera.exe$\" /HideIconsCommand"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\InstallInfo" "ReinstallCommand" "$\"$INSTDIR\Opera.exe$\" /ReInstallBrowser"
;
WriteRegDWORD HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\InstallInfo" "IconsVisible" 0x1
;
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
;
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\shell\properties" "" " Opera"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\shell\properties\command" "" "$\"$INSTDIR\Opera.exe$\" opera:config"
;
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities" "ApplicationDescription" "The Best Internet Experience on any device"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities" "ApplicationName" "Opera Web browser"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities" "ApplicationIcon" "$\"$INSTDIR\Opera.exe$\",0"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".wgt" "Opera.Widget"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".oex" "Opera.Extension"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".htm" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".html" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".xht" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".xhtm" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".xhtml" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".mht" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".mhtml" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".xml" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".torrent" "Opera.HTML"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".bmp" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".jpeg" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".jpg" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".png" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".svg" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".gif" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".xbm" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".oga" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".ogv" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".ogm" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".ogg" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\FileAssociations" ".webm" "Opera.Image"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\Startmenu" "Mail" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\Startmenu" "StartMenuInternet" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "http" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "https" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "ftp" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "mailto" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "nntp" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "news" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\Capabilities\UrlAssociations" "snews" "Opera.Protocol"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",0"
;
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe" "" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe" "LocalizedString" "Opera Internet Browser"
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
;
WriteRegStr HKLM "SOFTWARE\RegisteredApplications" "Opera Internet Browser" "Software\Clients\StartMenuInternet\Opera\Capabilities"
;
WriteRegBin HKLM "SOFTWARE\Classes\.bmp\OpenWithProgids" "Opera.Image" "" 
WriteRegBin HKLM "SOFTWARE\Classes\.gif\OpenWithProgids" "Opera.Image" "" 
WriteRegBin HKLM "SOFTWARE\Classes\.jpg\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.jpeg\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.oga\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.ogg\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.ogm\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.ogv\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.png\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.webm\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.xbm\OpenWithProgids" "Opera.Image" ""
WriteRegBin HKLM "SOFTWARE\Classes\.torrent\OpenWithProgids" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.htm" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.htm\OpenWithProgids" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.html" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.html\OpenWithProgids" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.mht" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.mht\OpenWithProgids" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.mhtml" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.mhtml\OpenWithProgIds" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.xht" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.xht\OpenWithProgIDs" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.xhtm" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.xhtm\OpenWithProgIDs" "Opera.HTML" "" 
;
WriteRegStr HKLM "SOFTWARE\Classes\.xhtml" "" "Opera.HTML"
WriteRegBin HKLM "SOFTWARE\Classes\.xhtml\OpenWithProgIDs" "Opera.HTML" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.xml" "" "xmlfile"
WriteRegBin HKLM "SOFTWARE\Classes\.xml\OpenWithProgIds" "Opera.HTML" ""
WriteRegStr HKLM "SOFTWARE\Classes\.xml" "Content Type" "text/xml"
;
WriteRegStr HKLM "SOFTWARE\Classes\.wgt" "" "Opera.Widget"
WriteRegBin HKLM "SOFTWARE\Classes\.wgt\OpenWithProgIDs" "Opera.Widget" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\.oex" "" "Opera.Extension"
WriteRegBin HKLM "SOFTWARE\Classes\.oex\OpenWithProgIDs" "Opera.Extension" ""
;
WriteRegStr HKLM "SOFTWARE\Classes\http" "URL Protocol" ""
WriteRegDWORD HKLM "SOFTWARE\Classes\http" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Classes\HTTP\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell" "" "open"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Classes\https" "URL Protocol" ""
WriteRegDWORD HKLM "SOFTWARE\Classes\https" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Classes\https\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell" "" "open"
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Protocol" "FriendlyTypeName" "Opera Protocol"
WriteRegDWORD HKLM "SOFTWARE\Classes\Opera.Protocol" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Protocol" "URL Protocol" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Protocol\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Protocol\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Protocol\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Protocol\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Extension" "" "Image"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Extension" "FriendlyTypeName" "Opera Extension"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Extension\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",5"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Extension\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Extension\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Extension\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Classes\Opera.HTML" "" "HTML Document"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.HTML" "FriendlyTypeName" "Opera Web Document"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.HTML\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.HTML\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.HTML\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.HTML\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Image" "" "Image"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Image" "FriendlyTypeName" "Opera Image"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Image\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Image\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Image\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Image\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Widget" "" "Image"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Widget" "FriendlyTypeName" "Opera Widget"
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Widget\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",4" 
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Widget\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Widget\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Classes\Opera.Widget\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" -widget $\"%1$\""
;
WriteRegStr HKCU "Software\Classes\.htm" "" "Opera.HTML"
WriteRegStr HKCU "Software\Classes\.html" "" "Opera.HTML"
WriteRegStr HKCU "Software\Classes\.mht" "" "Opera.HTML"
WriteRegStr HKCU "Software\Classes\.mhtml" "" "Opera.HTML"
WriteRegStr HKCU "Software\Classes\.xht" "" "Opera.HTML"
WriteRegStr HKCU "Software\Classes\.xhtm" "" "Opera.HTML"
WriteRegStr HKCU "Software\Classes\.xhtml" "" "Opera.HTML"
;
WriteRegStr HKCU "Software\Classes\HTTP" "URL Protocol" ""
WriteRegDWORD HKCU "Software\Classes\HTTP" "EditFlags" 0x2
WriteRegStr HKCU "Software\Classes\Opera.Extension\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKCU "Software\Classes\HTTP\shell" "" ""
WriteRegStr HKCU "Software\Classes\HTTP\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\HTTP\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
WriteRegStr HKCU "Software\Classes\HTTP\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\HTTP\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\HTTP\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Classes\https" "URL Protocol" ""
WriteRegDWORD HKCU "Software\Classes\https" "EditFlags" 0x2
WriteRegStr HKCU "Software\Classes\https\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKCU "Software\Classes\https\shell" "" ""
WriteRegStr HKCU "Software\Classes\https\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\https\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
WriteRegStr HKCU "Software\Classes\https\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\https\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\https\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Classes\Opera.Extension" "FriendlyTypeName" "Opera Extension"
WriteRegStr HKCU "Software\Classes\Opera.Extension\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",5"
WriteRegStr HKCU "Software\Classes\Opera.Extension\shell" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Extension\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Extension\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
WriteRegStr HKCU "Software\Classes\Opera.Extension\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\Opera.Extension\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Extension\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Classes\Opera.HTML" "FriendlyTypeName" "Opera Web Document"
WriteRegStr HKCU "Software\Classes\Opera.HTML\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKCU "Software\Classes\Opera.HTML\shell" "" ""
WriteRegStr HKCU "Software\Classes\Opera.HTML\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\Opera.HTML\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
WriteRegStr HKCU "Software\Classes\Opera.HTML\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\Opera.HTML\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\Opera.HTML\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Classes\Opera.Image" "FriendlyTypeName" "Opera Image"
WriteRegStr HKCU "Software\Classes\Opera.Image\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKCU "Software\Classes\Opera.Image\shell" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Image\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Image\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
WriteRegStr HKCU "Software\Classes\Opera.Image\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\Opera.Image\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Image\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Classes\Opera.Widget" "FriendlyTypeName" "Opera Widget"
WriteRegStr HKCU "Software\Classes\Opera.Widget\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",4"
WriteRegStr HKCU "Software\Classes\Opera.Widget\shell" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Widget\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Widget\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" -widget"
WriteRegStr HKCU "Software\Classes\Opera.Widget\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\Opera.Widget\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Widget\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Classes\Opera.Protocol" "FriendlyTypeName" "Opera Protocol"
WriteRegDWORD HKCU "Software\Classes\Opera.Protocol" "EditFlags" 0x2
WriteRegStr HKCU "Software\Classes\Opera.Protocol" "URL Protocol" ""
WriteRegStr HKCU "Software\Classes\Opera.Protocol\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKCU "Software\Classes\Opera.Protocol\shell" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Protocol\shell\open" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Protocol\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\""
WriteRegStr HKCU "Software\Classes\Opera.Protocol\shell\open\ddeexec" "" "$\"%1$\""
WriteRegStr HKCU "Software\Classes\Opera.Protocol\shell\open\ddeexec\Application" "" ""
WriteRegStr HKCU "Software\Classes\Opera.Protocol\shell\open\ddeexec\Topic" "" ""
;
WriteRegStr HKCU "Software\Clients\StartMenuInternet" "" "Opera"
;
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera" "" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera" "LocalizedString" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",3"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\InstallInfo" "ShowIconsCommand" "$\"$INSTDIR\Opera.exe$\" /ShowIconsCommand"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\InstallInfo" "HideIconsCommand" "$\"$INSTDIR\Opera.exe$\" /HideIconsCommand"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\InstallInfo" "ReinstallCommand" "$\"$INSTDIR\Opera.exe$\" /ReInstallMailer"
WriteRegDWORD HKLM "SOFTWARE\Clients\Mail\Opera\InstallInfo" "IconsVisible" 0x1
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto" "" "URL:MailTo Protocol"
WriteRegDWORD HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto" "URL Protocol" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",3"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\Protocols\mailto\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" /Mail"
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\shell\properties" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\Mail\Opera\shell\properties\command" "" "$\"$INSTDIR\Opera.exe$\" opera:config#Mail"
;
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera" "" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera" "LocalizedString" "Opera"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",3"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\InstallInfo" "ShowIconsCommand" "$\"$INSTDIR\Opera.exe$\" /ShowIconsCommand"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\InstallInfo" "HideIconsCommand" "$\"$INSTDIR\Opera.exe$\" /HideIconsCommand"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\InstallInfo" "ReinstallCommand" "$\"$INSTDIR\Opera.exe$\" /ReInstallNewsReader"
WriteRegDWORD HKLM "SOFTWARE\Clients\News\Opera\InstallInfo" "IconsVisible" 0x1
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\news" "" "URL:MailTo Protocol"
WriteRegDWORD HKLM "SOFTWARE\Clients\News\Opera\Protocols\news" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\news" "URL Protocol" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\news\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\news\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\news\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\news\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp" "" "URL:MailTo Protocol"
WriteRegDWORD HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp" "URL Protocol" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\nntp\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews" "" "URL:MailTo Protocol"
WriteRegDWORD HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews" "URL Protocol" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews\DefaultIcon" "" "$\"$INSTDIR\Opera.exe$\",1"
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews\shell" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews\shell\open" "" ""
WriteRegStr HKLM "SOFTWARE\Clients\News\Opera\Protocols\snews\shell\open\command" "" "$\"$INSTDIR\Opera.exe$\" $\"%1$\""
;
SectionEnd
;
!macro CreateInternetShortcut FILENAME URL ICONFILE ICONINDEX
WriteINIStr "${FILENAME}.url" "InternetShortcut" "URL" "${URL}"
WriteINIStr "${FILENAME}.url" "InternetShortcut" "IconFile" "${ICONFILE}"
WriteINIStr "${FILENAME}.url" "InternetShortcut" "IconIndex" "${ICONINDEX}"
!macroend
;
SectionGroup " " ID_6
Section "   " ID_7
SetOutPath "$INSTDIR"
SetShellVarContext all
CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\opera.exe"
CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe"
!insertmacro CreateInternetShortcut \
  "$SMPROGRAMS\${PRODUCT_NAME}\- Opera" \
  "${PRODUCT_WEB_SITE}" \ 
  "$INSTDIR\operaURL.ico" "0"
SectionEnd
;
Section "   " ID_8
SetOutPath "$INSTDIR"
CreateShortCut "$Desktop\${PRODUCT_NAME}.lnk" "$INSTDIR\opera.exe"
SectionEnd
;
Section "    " ID_9
SetOutPath "$INSTDIR"
CreateShortCut "$QUICKLAUNCH\${PRODUCT_NAME}.lnk" "$INSTDIR\opera.exe"
SectionEnd
SectionGroupEnd
;
Section " " ID_10
SetOutPath "$INSTDIR"
File /r "${pkgdir}\Opera11\custom"
;
ReadINIStr $0 "$INSTDIR\operaprefs_default.ini" "System" "Multi User"
StrCmp $0 "1" 0 no_multi_user 
SetShellVarContext current
SetOutPath "$APPDATA"
CreateDirectory "$APPDATA\Opera\Opera\"
SetOverwrite on
CopyFiles /silent "$INSTDIR\custom\profile\search.ini" "$APPDATA\Opera\Opera\search.ini"
WriteINIStr "$APPDATA\Opera\Opera\operaprefs.ini" "State" "Data2" "02827edd9d4c131d98daea963133db3d757"
WriteINIStr "$APPDATA\Opera\Opera\operaprefs.ini" "State" "Data4" "004283130a2be3af796264a9071790fff30"
Goto Done
no_multi_user:
SetOutPath "$INSTDIR"
CreateDirectory "$INSTDIR\profile\"
SetOverwrite on
CopyFiles /silent "$INSTDIR\custom\profile\search.ini" "$INSTDIR\profile\search.ini"
WriteINIStr "$INSTDIR\profile\operaprefs.ini" "State" "Data2" "02827edd9d4c131d98daea963133db3d757"
WriteINIStr "$INSTDIR\profile\operaprefs.ini" "State" "Data4" "004283130a2be3af796264a9071790fff30"
Done:
SetOutPath "$INSTDIR"
RMDir /r "$INSTDIR\custom\profile\"
SectionEnd
;
Section "    Opera" ID_11
SetOutPath "$INSTDIR"
CreateDirectory "$INSTDIR\skin"
SetOutPath "$INSTDIR\skin"
File "${pkgdir}\Opera11\addons\affinity_3_-_opera_fan_club-11102.zip"
File "${pkgdir}\Opera11\addons\c00-0_16.zip"
File "${pkgdir}\Opera11\addons\v7-glass-5_4_13.zip"
File "${pkgdir}\Opera11\addons\ibis_inspire-3_74.zip"
SectionEnd
;
Section "   Opera" ID_12
SetOutPath "$INSTDIR"
CreateDirectory "$INSTDIR\extensions" 
SetOutPath "$INSTDIR\extensions" 
File "${pkgdir}\Opera11\addons\fastesttube-youtube-video-downloader-1.0.1-1.oex"
File "${pkgdir}\Opera11\addons\lastpass-1.73.9-1.oex"
File "${pkgdir}\Opera11\addons\noads-fixed-2-1.0.8-fixed_Opera11-1.oex"
File "${pkgdir}\Opera11\addons\opera-internal-pages-1.2-3-1.oex"
File "${pkgdir}\Opera11\addons\lentaru-chitai-seichas-1.0-1.oex"
File "${pkgdir}\Opera11\addons\translate-1.5-1.oex"
File "${pkgdir}\Opera11\addons\savefromnet-helper-1.29-1.oex"
File "${pkgdir}\Opera11\addons\oGet_setup.exe"
SectionEnd

Section "   Opera" ID_13
SetOutPath "$INSTDIR"
CreateDirectory "$INSTDIR\widgets"
SetOutPath "$INSTDIR\widgets"
File "${pkgdir}\Opera11\addons\Widget_Calculator-Widget_3530-1.7.wgt"
File "${pkgdir}\Opera11\addons\Widget_Daily-Calendar_4166-1.0.wgt"
File "${pkgdir}\Opera11\addons\Widget_Digital-Clock_26161-1.0.wgt"
SectionEnd
;
Function .onSelChange 
!insertmacro StartRadioButtons $1 
!insertmacro RadioButton ${ID_3}
!insertmacro RadioButton ${ID_4}
!insertmacro EndRadioButtons 
FunctionEnd

Function .onInit 
StrCpy $SysDrive $WINDIR 2 
StrCpy $1 ${ID_3}
FunctionEnd
;
Section "-Post" PostInstall
${RefreshShellIcons}
SectionEnd 
;
Function un.onInit
SectionSetText ${ID_14} " Opera"
StrCpy $SysDrive $WINDIR 2 
FunctionEnd
;
Function un.RefreshShellIcons
 System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
 (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd
;
Section Uninstall  ID_14
SectionIn 1 RO
;
SetShellVarContext all
RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
Delete "$Desktop\${PRODUCT_NAME}.lnk"
Delete "$QUICKLAUNCH\${PRODUCT_NAME}.lnk"
DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
;
;01
ReadRegStr $0 HKLM "Software\Classes\.htm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.htm" ""
;02
ReadRegStr $0 HKLM "Software\Classes\.html" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.html" ""
;03
ReadRegStr $0 HKLM "Software\Classes\.mht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.mht" ""
;04
ReadRegStr $0 HKLM "Software\Classes\.mhtml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.mhtml" ""
;05
ReadRegStr $0 HKLM "Software\Classes\.xht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.xht" ""
;06
ReadRegStr $0 HKLM "Software\Classes\.xhtm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.xhtm" ""
;07
ReadRegStr $0 HKLM "Software\Classes\.xml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKLM "Software\Classes\.xml" ""
;08
ReadRegStr $0 HKLM "Software\Classes\.wgt" ""
StrCmp $0 "Opera.Widget" 0 +2
DeleteRegValue HKLM "Software\Classes\.wgt" ""
;09
ReadRegStr $0 HKLM "Software\Classes\.oex" ""
StrCmp $0 "Opera.Extension" 0 +2
DeleteRegValue HKLM "Software\Classes\.oex" ""
;1
ReadRegStr $0 HKCU "Software\Classes\.htm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.htm" ""
;2
ReadRegStr $0 HKCU "Software\Classes\.html" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.html" ""
;3
ReadRegStr $0 HKCU "Software\Classes\.mht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.mht" ""
;4
ReadRegStr $0 HKCU "Software\Classes\.mhtml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.mhtml" ""
;5
ReadRegStr $0 HKCU "Software\Classes\.xht" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.xht" ""
;6
ReadRegStr $0 HKCU "Software\Classes\.xhtm" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.xhtm" ""
;7
ReadRegStr $0 HKCU "Software\Classes\.xml" ""
StrCmp $0 "Opera.HTML" 0 +2
DeleteRegValue HKCU "Software\Classes\.xml" ""
;8
ReadRegStr $0 HKCU "Software\Classes\.wgt" ""
StrCmp $0 "Opera.Widget" 0 +2
DeleteRegValue HKCU "Software\Classes\.wgt" ""
;9
ReadRegStr $0 HKCU "Software\Classes\.oex" ""
StrCmp $0 "Opera.Extension" 0 +2
DeleteRegValue HKCU "Software\Classes\.oex" ""
;
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Widget" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Protocol" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Extension" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.HTML" ""
DeleteRegKey HKLM "SOFTWARE\Classes\Opera.Image" ""
;
DeleteRegKey HKCU "Software\Classes\Opera.Widget" ""
DeleteRegKey HKCU "Software\Classes\Opera.Protocol" ""
DeleteRegKey HKCU "Software\Classes\Opera.Extension" ""
DeleteRegKey HKCU "Software\Classes\Opera.HTML" ""
DeleteRegKey HKCU "Software\Classes\Opera.Image" ""
;
DeleteRegKey /ifempty HKCU "Software\Classes\.htm" 
DeleteRegKey /ifempty HKCU "Software\Classes\.html" 
DeleteRegKey /ifempty HKCU "Software\Classes\.mht" 
DeleteRegKey /ifempty HKCU "Software\Classes\.mhtml" 
DeleteRegKey /ifempty HKCU "Software\Classes\.xht" 
DeleteRegKey /ifempty HKCU "Software\Classes\.xhtm" 
DeleteRegKey /ifempty HKCU "Software\Classes\.xml" 
DeleteRegKey /ifempty HKCU "Software\Classes\.wgt" 
DeleteRegKey /ifempty HKCU "Software\Classes\.oex" 
;
DeleteRegValue HKLM "SOFTWARE\Classes\.bmp\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.gif\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.jpg\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.jpeg\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.oga\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.ogg\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.ogm\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.ogv\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.png\OpenWithProgids" "Opera.Image" 
DeleteRegValue HKLM "SOFTWARE\Classes\.torrent\OpenWithProgids" "Opera.HTML" 
DeleteRegValue HKLM "SOFTWARE\Classes\.webm\OpenWithProgids" "Opera.Image" 
;
DeleteRegKey HKLM "SOFTWARE\Opera Software" ""
;
DeleteRegKey HKLM "SOFTWARE\Classes\Applications\Opera.exe" ""
;
DeleteRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\opera.exe" ""
;
DeleteRegValue HKLM "SOFTWARE\RegisteredApplications" "Opera Internet Browser" 
;
DeleteRegKey HKLM "SOFTWARE\Clients\StartMenuInternet\Opera.exe" ""
DeleteRegKey HKLM "SOFTWARE\Clients\StartMenuInternet\Opera" ""
DeleteRegKey HKCU "Software\Clients\StartMenuInternet\Opera" ""
;
DeleteRegKey HKLM "SOFTWARE\Clients\Mail\Opera" ""
DeleteRegKey HKLM "SOFTWARE\Clients\News\Opera" ""
;
DeleteRegKey HKLM "SOFTWARE\Netscape\Netscape Navigator\Opera" ""
;
ReadRegStr $0 HKLM "SOFTWARE\Netscape\Netscape Navigator" "CurrentVersion"
StrCmp $0 "Opera" 0 +2
DeleteRegValue HKLM "SOFTWARE\Netscape\Netscape Navigator" "CurrentVersion"
;
DeleteRegValue HKLM "SYSTEM\CurrentControlSet\Services\SharedAccess\Parameters\FirewallPolicy\StandardProfile\AuthorizedApplications\List" "$PROGRAMFILES\Opera\opera.exe" 

DeleteRegValue HKLM "SYSTEM\ControlSet002\Services\SharedAccess\Parameters\FirewallPolicy\StandardProfile\AuthorizedApplications\List" "$PROGRAMFILES\Opera\opera.exe" 
;
DeleteRegKey HKCU "Software\Opera Software" ""
;
DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\MenuOrder\Start Menu2\Programs\Opera" 
;
DeleteRegKey HKLM "SOFTWARE\Microsoft\MediaPlayer\ShimInclusionList\OPERA.EXE" "" 
;
DeleteRegKey HKLM "SOFTWARE\Classes\CLSID\{42042206-2D85-11D3-8CFF-005004838597}\Old Icon\Opera.HTML" "" 
;
DeleteRegKey HKCR "CLSID\{42042206-2D85-11D3-8CFF-005004838597}\Old Icon\Opera.HTML" ""
;
Call un.RefreshShellIcons
;
RMDir /r "$INSTDIR"
SetAutoClose true
SectionEnd
;
Section "Un.    "  ID_15
SectionIn 1 
SetShellVarContext current
RMDir /r "$APPDATA\Opera\"
RMDir /r "$LOCALAPPDATA\Opera\" 
SetShellVarContext all
RMDir /r "$APPDATA\Opera\"
RMDir /r "$LOCALAPPDATA\Opera\" 
;
StrCpy $R0 "$SysDrive\Documents and Settings\\Local Settings\Application Data\Opera\"
SetEnv::SetEnvVar "PATH" $R0
RMDir /r "$R0\"
;
StrCpy $R1 "$SysDrive\Documents and Settings\\Application Data\Opera\"
SetEnv::SetEnvVar "PATH" $R1
RMDir /r "$R1\"
SectionEnd
;
Section "Un. Internet Explorer -  "  ID_16
WriteRegStr HKLM "SOFTWARE\Clients\StartMenuInternet" "" "IEXPLORE.EXE"
;
WriteRegStr HKLM "SOFTWARE\Classes\.htm" "" "htmlfile"
WriteRegStr HKLM "SOFTWARE\Classes\.html" "" "htmlfile"
WriteRegStr HKLM "SOFTWARE\Classes\.mht" "" "mhtmlfile"
WriteRegStr HKLM "SOFTWARE\Classes\.mhtml" "" "mhtmlfile"
;
WriteRegDWORD HKLM "SOFTWARE\Classes\http" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Classes\http\DefaultIcon" "" "$SYSDIR\url.dll,0"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open\command" "" "$\"$PROGRAMFILES\Internet Explorer\IEXPLORE.EXE$\" -nohome"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open\ddeexec" "" "$\"%1$\",,-1,0,,,,"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open\ddeexec" "NoActivateHandler" ""
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open\ddeexec\Application" "" "IExplore"
WriteRegStr HKLM "SOFTWARE\Classes\http\shell\open\ddeexec\Topic" "" "WWW_OpenURL"
;
WriteRegDWORD HKLM "SOFTWARE\Classes\https" "EditFlags" 0x2
WriteRegStr HKLM "SOFTWARE\Classes\https\DefaultIcon" "" "$SYSDIR\url.dll,0"
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open\command" "" "$\"$PROGRAMFILES\Internet Explorer\IEXPLORE.EXE$\" -nohome"
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open\ddeexec" "" "$\"%1$\",,-1,0,,,,"
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open\ddeexec" "NoActivateHandler" ""
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open\ddeexec\Application" "" "IExplore"
WriteRegStr HKLM "SOFTWARE\Classes\https\shell\open\ddeexec\Topic" "" "WWW_OpenURL"
Call un.RefreshShellIcons
SectionEnd
;
LangString message ${LANG_ENGLISH} "Here is in English" 
LangString message ${LANG_RUSSIAN} "   "
LangString DESC_01 ${LANG_RUSSIAN} "           Opera"
LangString DESC_02 ${LANG_RUSSIAN} "     - ${PRODUCT_NAME} ${PRODUCT_VERSION}"
LangString DESC_03 ${LANG_RUSSIAN} "    Opera"
LangString DESC_04 ${LANG_RUSSIAN} "    Opera"
LangString DESC_05 ${LANG_RUSSIAN} "Opera    -  "
LangString DESC_06 ${LANG_RUSSIAN} "   ,       Opera"
LangString DESC_07 ${LANG_RUSSIAN} "   Opera   "
LangString DESC_08 ${LANG_RUSSIAN} "  Opera   "
LangString DESC_09 ${LANG_RUSSIAN} "  Opera    "
LangString DESC_10 ${LANG_RUSSIAN} "    -,     "
LangString DESC_11 ${LANG_RUSSIAN} "      Opera"
LangString DESC_12 ${LANG_RUSSIAN} "  Extensions     Opera"
LangString DESC_13 ${LANG_RUSSIAN} "  Widgets     Opera"
LangString DESC_14 ${LANG_RUSSIAN} "  Opera     "
LangString DESC_15 ${LANG_RUSSIAN} ",      Opera     "
LangString DESC_16 ${LANG_RUSSIAN} "  Internet Explorer   "
;
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN 
!insertmacro MUI_DESCRIPTION_TEXT ${ID_1} $(DESC_01) 
!insertmacro MUI_DESCRIPTION_TEXT ${ID_2} $(DESC_02) 
!insertmacro MUI_DESCRIPTION_TEXT ${ID_3} $(DESC_03)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_4} $(DESC_04)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_5} $(DESC_05)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_6} $(DESC_06)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_7} $(DESC_07)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_8} $(DESC_08)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_9} $(DESC_09)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_10} $(DESC_10)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_11} $(DESC_11)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_12} $(DESC_12)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_13} $(DESC_13)

!insertmacro MUI_FUNCTION_DESCRIPTION_END
;
!insertmacro MUI_UNFUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${ID_14} $(DESC_14)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_15} $(DESC_15)
!insertmacro MUI_DESCRIPTION_TEXT ${ID_16} $(DESC_16)
!insertmacro MUI_UNFUNCTION_DESCRIPTION_END
